/*
 * Forest.h
 *
 *  Created on: 06.02.2012
 *      Author: Markus Bals
 */

#ifndef FOREST_H_
#define FOREST_H_

#include "ignf.h"

namespace IGNF {

class Forest {

private:
	StringGrammar m_grammar;
	map<Symbol,Tree*> m_trees;

public:
	Forest();
	virtual ~Forest();

	TreeNode* insertProduction(StringProduction production);
	TreeNode* insertProduction(Production production);
	Tree* operator[](const Symbol lhs);
	set<Symbol> getRootLabels();
	set<Tree*> getTrees();

	void resetFollowedMarkers();
	void resetNewMarkers();

	string decodeNode2String(TreeNode* node);
	string getEncodingTableString();
	string getProductionsString(set<Production> productions, bool compact);

private:
	void createTreeIfNotExistent(Symbol lhs);
};

} /* namespace IGNF */
#endif /* FOREST_H_ */
