/*
 * GrammarReader.h
 *
 *      Created on: 19.01.2012
 *          Author: Markus Bals
 *  Responsibility: Read a text file, identify productions and supply them via readNext() method
 *     Description: Utility class to read user defined grammars from text files.
 *                  Separate productions always by | and symbols within a word by a blank
 *                  Example: C -> while B do C | C ; C
 */

#ifndef GRAMMARREADER_H_
#define GRAMMARREADER_H_

#include "ignf.h"

namespace IGNF {

class GrammarReader {

private:
	vector<StringProduction> m_productions;
	vector<StringProduction>::iterator m_iter;
public:
	GrammarReader();
	virtual ~GrammarReader();

	void readGrammarFile(string filename, const string& delimiters=" ");
	StringProduction readProduction(string raw, const string& delimiters=" ");
	bool good();
	StringProduction getNextProduction();

private:
	vector<StringProduction> parseLine(string line, const string& delimiters);
	void tokenize(const string& str, vector<string>& tokens, const string& delimiters = " ");
};

} /* namespace IGNF */
#endif /* GRAMMARREADER_H_ */
