/*
 * IncrementalAlgorithm.h
 *
 *  Created on: 06.02.2012
 *      Author: Markus Bals
 */

#ifndef INCREMENTALALGORITHM_H_
#define INCREMENTALALGORITHM_H_

#include "ignf.h"

namespace IGNF {

class IncrementalAlgorithm {

private:
	Forest m_forest;
	Worklist<TreeNode*> m_orderingList, m_greibachList, m_finalList;

	map<Symbol, set<Production> > m_oldProductions;
	set<TreeNode*> m_newNodes;

public:
	IncrementalAlgorithm();
	virtual ~IncrementalAlgorithm();

	void runOnGrammarFile(string filename);

	void DT38_extendGrammar(string raw);
	void DT38_extendGrammar(StringProduction production);
	TreeNode* DT32_insertProduction(Production encoded);
	TreeNode* DT32_insertProduction(StringProduction production);
	void DT33_checkPointerAndWorklist(TreeNode* node);
	void DT36_processWorklist(Worklist<TreeNode*>& worklist, PassType pass);
	void DT37_followPointers(Tree* tree, UsgPtrType ptrType);
	void DT39_leftDerivation(TreeNode* node, PassType pass);
	void DT35_removeRecursion(TreeNode *node);

	void showEncodingTable();
	void showProductions();

private:
	void cleanup();
	void memorizeOldProductions();
	void insertedNewRootChild(TreeNode* node);
	void replaceByLeftDerivations(TreeNode* node, set<Production> replace);
	void createProductionsOfRRSymbol(Production production);

	string getCurrentProductionsString();
};

} /* namespace IGNF */
#endif /* INCREMENTALALGORITHM_H_ */
