/*
 * StringGrammar.h
 *
 *  Created on: 19.01.2012
 *      Author: Markus Bals
 */

#ifndef STRINGGRAMMAR_H_
#define STRINGGRAMMAR_H_

#include "ignf.h"

namespace IGNF {

class StringGrammar {
private:
	set<Production> m_productions;
	map<Symbol, string> m_names;
	map<string, Symbol> m_symbols;

public:
	StringGrammar();
	StringGrammar(map<Symbol, string> names, map<string, Symbol> symbols);
	virtual ~StringGrammar();

	void initFromFile(string filename);
	void appendFromFile(string filename);

	void addProduction(StringProduction strProduction);
	void addProduction(Production production);
	void addProductions(set<Production> productions);
	void removeProduction(Production production);
	set<Production> getProductions(Symbol lhs=0);

	string getEncodingTableString();
	string getProductionString(Production production, bool rhsOnly=false);
	string getProductionsString(set<Production> productions=set<Production>(), bool compact=false);

	static set<Production> getLeftDerivations(
			const Production& replaced, const set<Production>& rhsList);
	static set<Production> getRightRecursiveReplacement(
			const Production& removed, const set<Production>& nonRecursive, const bool& rrExists);
	static bool ordered(Production production);
	static bool greibach(Production production);
	static bool recursive(Production production);

	static string getEncodedProductionString(Production production);
	static string joinStringProduction(StringProduction strProduction);


	bool checkRecursiveSymbol(Symbol regular);

	Production encodeProduction(StringProduction rule);

private:
	Symbol encodeNonterminal(string str);
	Symbol encodeSymbol(string str);
	StringProduction decodeProduction(Production rule);
	string decodeSymbol(Symbol symbol);

};

} /* namespace IGNF */
#endif /* STRINGGRAMMAR_H_ */
