/*
 * Tree.cpp
 *
 *  Created on: 06.02.2012
 *      Author: Markus Bals
 */

#include "ignf.h"

namespace IGNF {


Tree::Tree(TreeNode* root) {
	m_root = root;
	m_extended = false;
	m_followed = false;
	m_newNodes = true;
}



Tree::~Tree() {
	delete m_root;
}



TreeNode* Tree::getRoot() {
	return m_root;
}

TreeNode* Tree::addRootChild(Production p) {
  return m_root->addChild(p);
}

void Tree::extend() {
	m_extended = true;
}



bool Tree::isExtended() {
	return m_extended;
}

void Tree::addForwardPointer(TreeNode* destination) {
	m_ptrFwd.insert(destination);
}

void Tree::addBackwardPointer(TreeNode* destination) {
	m_ptrBck.insert(destination);
}

void Tree::addFinalPointer(TreeNode* destination) {
	m_ptrFin.insert(destination);
}

set<TreeNode*> Tree::getUsagePointerDestinations(UsgPtrType upType) {
	if ( upType == UPforward )
		return m_ptrFwd;
	else if ( upType == UPbackward )
		return m_ptrBck;
	else
		return m_ptrFin;
}


bool Tree::wasFollowed() {
	return m_followed;
}

void Tree::setFollowed(bool followed) {
	m_followed = followed;
}

bool Tree::hasNewNodes() {
	return m_newNodes;
}

void Tree::setNewNodes(bool newNodes) {
	m_newNodes = newNodes;
}

set<Production> Tree::getRepresentedProductions() {
	set<Production> result;
	depthFirst(m_root, &result, false);
	return result;
}

set<Production> Tree::getFONProductions() {
	set<Production> result;
	depthFirst(m_root, &result, true);
	return result;
}

void Tree::depthFirst(TreeNode* node, set<Production>* result, bool fon) {
	int count = node->getChildCount();
	bool ordered = StringGrammar::ordered(node->getProduction());

	if ( (ordered && fon) || (!fon && count == 0) ) {
		if ( node->isBlind() )
			return;
		result->insert(node->getProduction());
		if ( m_extended && !node->isDirectLeftRecursive() )
			result->insert(node->getRightRecursiveCopy());
	}
	else if ( fon && count == 0 ) {
		cout << "Warning: invalid node (not ordered and no child nodes)\n";
		return;
	}
	else for (int i=0; i<count; i++) {
		depthFirst(node->getChild(i), result, fon);
	}
}

}/* namespace IGNF */
