/*
 * Tree.h
 *
 *  Created on: 06.02.2012
 *      Author: Markus Bals
 */

#ifndef TREE_H_
#define TREE_H_

#include "ignf.h"

namespace IGNF {

class Tree {

private:
	TreeNode* m_root;
	bool m_extended;
	set<TreeNode*> m_ptrFwd, m_ptrBck, m_ptrFin;

	bool m_followed, m_newNodes;

public:
	Tree(TreeNode* root);
	virtual ~Tree();


	TreeNode* getRoot();
	TreeNode* addRootChild(Production p);
	void extend();
	bool isExtended();

	void addForwardPointer(TreeNode* destination);
	void addBackwardPointer(TreeNode* destination);
	void addFinalPointer(TreeNode* destination);
	set<TreeNode*> getUsagePointerDestinations(UsgPtrType upType);

	bool wasFollowed();
	void setFollowed(bool followed);
	bool hasNewNodes();
	void setNewNodes(bool newNodes);

	set<Production> getRepresentedProductions();
	set<Production> getFONProductions();

private:
	void depthFirst(TreeNode* node, set<Production>* result, bool fon);
};

} /* namespace IGNF */
#endif /* TREE_H_ */
