/*
 * TreeNode.cpp
 *
 *  Created on: 06.02.2012
 *      Author: Markus Bals
 */

#include "ignf.h"

namespace IGNF {

TreeNode::TreeNode(Production production) {
	m_production = production;
	m_new = true;
	m_blind = false;
}

TreeNode::~TreeNode() {
	m_children.clear();
}

Production TreeNode::getProduction() const {
  return m_production;
}

Production TreeNode::getRightRecursiveCopy() const {
	Production rrCopy = m_production;
	Symbol rrSymbol = (IS_RECURSIVE_SYMBOL(m_production.first) ?
			m_production.first : RECURSIVE_SYMBOL(m_production.first));
	rrCopy.second.push_back(rrSymbol);
	return rrCopy;
}

Symbol TreeNode::getLeftmostRHS() const {
  if ( m_production.second.empty() )
	  return 0;
  return m_production.second[0];
}

Symbol TreeNode::getLHS() const {
	return m_production.first;
}

void TreeNode::setParent(TreeNode *parent) {
	m_parent = parent;
}

TreeNode *TreeNode::getParent() {
	return m_parent;
}

TreeNode* TreeNode::addChild(Production p) {
	TreeNode* newChild = new TreeNode(p);
	m_children.insert(newChild);
	return newChild;
}

int TreeNode::getChildCount() {
	return m_children.size();
}

TreeNode* TreeNode::getChild(const int index) {
	set<TreeNode*>::iterator it = m_children.begin();
	for(int i=0; i<index; i++) it++;
	return *(it);
}

bool TreeNode::isDirectLeftRecursive() {
	if ( m_production.second.empty() )
		return false;
	return (m_production.first == m_production.second[0]);
}

void TreeNode::setBlind() {
	m_blind = true;
}

bool TreeNode::isBlind() {
	return m_blind;
}

void TreeNode::setOld() {
	m_new = false;
}

bool TreeNode::isNew(){
	return m_new;
}


} /* namespace IGNF */
