/*
 * TreeNode.h
 *
 *  Created on: 06.02.2012
 *      Author: Markus Bals
 */

#ifndef TREENODE_H_
#define TREENODE_H_

#include "ignf.h"

namespace IGNF {

class TreeNode : virtual public IWorklistItem {

	struct TreeNodePtrLess: public binary_function<const TreeNode*, const TreeNode*, bool> {
		bool operator()(const TreeNode *p1, const TreeNode *p2) const {
			return *p1 < *p2;
	    }
	};

private:
	Production m_production;
	bool m_new, m_blind;
	set<TreeNode*, TreeNodePtrLess> m_children;
	TreeNode* m_parent;

public:
	TreeNode(Production production);
	virtual ~TreeNode();

	Production getProduction() const;
	Production getRightRecursiveCopy() const;
	Symbol getLeftmostRHS() const;
	Symbol getLHS() const;

	void setParent(TreeNode* parent);
	TreeNode* getParent();

	TreeNode* addChild(Production p);
	int getChildCount();
	TreeNode* getChild(const int index);

	bool isDirectLeftRecursive();

	void setBlind();
	bool isBlind();
	void setOld();
	bool isNew();
};

} /* namespace IGNF */
#endif /* TREENODE_H_ */
