/*
 * Worklist.cpp
 *
 *  Created on: 23.01.2012
 *      Author: Markus Bals
 */

//#include "ignf.h"

namespace IGNF {

template<class T>  Worklist<T>::Worklist(const bool& descending) {
	m_descending = descending;
}

template<class T> void Worklist<T>::setDescending(bool descending) {
	m_descending = descending;
}

template<class T> bool Worklist<T>::empty() {
	return m_list.empty();
}

template<class T> void Worklist<T>::insertItem(const T& item) {
	m_list.insert(item);
}

template<class T> T Worklist<T>::popItem() {
	assert( !m_list.empty() );

	class set<T>::iterator it = m_list.begin();

	if ( m_descending ) {
		it = m_list.end();
		--it;
	}

	T wlItem = (*it);
	m_list.erase( it );
#ifdef DEBUG
	cout << "(" << m_list.size() << " remaining)\n";
#endif
	return wlItem;
}

template<class T> void Worklist<T>::showWorklist() {
	class set<T>::iterator it = m_list.begin();

	cout << "Worklist items:\n";
	while ( it != m_list.end() ) {
		IWorklistItem *wlItem = (IWorklistItem*)&(*it);
		Production nextProduction = wlItem->getProduction();
		cout << "  " << StringGrammar::getEncodedProductionString(nextProduction) << "\n";
		it++;
	}
}


} /* namespace IGNF */
