/*
 * Worklist.h
 *
 *      Created on: 23.01.2012
 *          Author: Markus Bals
 *  Responsibility: manage a worklist of items that implement IWorklistItem
 */

#ifndef WORKLIST_H_
#define WORKLIST_H_

#include "ignf.h"

namespace IGNF {

template<class T> class Worklist {

private:
	set<T> m_list;
	bool m_descending;

public:
	Worklist(const bool& descending=false);
	//virtual ~Worklist() { }

	void setDescending(bool descending);
	bool empty();
	void insertItem(const T& item);
	T popItem();

	void showWorklist();

};

} /* namespace IGNF */

#include "Worklist.cpp"

#endif /* WORKLIST_H_ */
