/*
 * ignf.h
 *
 *  Created on: 19.01.2012
 *      Author: Markus Bals
 */

#ifndef IGNF_H_
#define IGNF_H_

#include <algorithm>
#include <cassert>
#include <fstream>
#include <iostream>
#include <map>
#include <set>
#include <sstream>
#include <string>
#include <sys/time.h>
#include <utility>
#include <vector>


using namespace std;

typedef pair< string, vector<string> > StringProduction;
typedef int Symbol;
typedef vector<Symbol> RHS;
typedef pair<Symbol, RHS> Production;

#define MIN_INT (int)0x80000000
#define MAX_INT (int)0x7FFFFFFF
#define MAX_REG_NONTERMINAL (-(1 << 13) - 1)
#define RECURSIVE_SYMBOL(x) (x + (1<<13))
#define REGULAR_SYMBOL(x) (x - (1<<13))
#define IS_RECURSIVE_SYMBOL(x) (x > MAX_REG_NONTERMINAL && x < 0)

namespace IGNF {
enum UsgPtrType {UPforward=1, UPbackward=2, UPfinal=3};
enum PassType {orderingPass=1, greibachPass=2, finalPass=3};
}

#include "GrammarReader.h"
#include "StringGrammar.h"
#include "IWorklistItem.h"
#include "WorklistProduction.h"
#include "Worklist.h"
#include "BasicAlgorithm.h"
#include "BasicAlgorithmSimple.h"

#include "TreeNode.h"
#include "Tree.h"
#include "Forest.h"
#include "IncrementalAlgorithm.h"

#include "Clock.h"
#include "AlgorithmWrapper.h"

#endif /* IGNF_H_ */
