tree grammar HRGBuilderGrammar;

options {
	language=Java;
	tokenVocab=HRG;
	output=AST;
	ASTLabelType=CommonTree;
}

@header {
package de.rwth.aachen.i2.graphreduction.newgrammar;
	
import de.rwth.aachen.i2.graphreduction.antlr.HRGUnknownTypeException;
import de.rwth.aachen.i2.graphreduction.antlr.HRGUnknownSelectorException;
import de.rwth.aachen.i2.graphreduction.antlr.HRGRankException;
import de.rwth.aachen.i2.graphreduction.antlr.HRGNotTypedNonterminalException;
import de.rwth.aachen.i2.graphreduction.grammar.Alphabet;
import de.rwth.aachen.i2.graphreduction.grammar.HRGrammar;
import de.rwth.aachen.i2.graphreduction.grammar.NodeType;
import de.rwth.aachen.i2.graphreduction.grammar.Nonterminal;
import de.rwth.aachen.i2.graphreduction.hypergraph.HyperGraph;
import de.rwth.aachen.i2.graphreduction.newgrammar.HRGCollectorGrammar.NodeInfo;
import de.rwth.aachen.i2.graphreduction.newgrammar.HRGCollectorGrammar.NonterminalInfo;
import de.rwth.aachen.i2.graphreduction.newgrammar.observer.*;

import java.util.Map;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Arrays;
}

@members {

	private Map<String, NonterminalInfo> nonterminalMap;
	
	private HRGrammar grammar; 
	private Alphabet alphabet;
	
	public HRGBuilderGrammar(TreeNodeStream input, HRGrammar grammar, Map<String, NonterminalInfo> nonterminalMap)
	{
		this(input);
		
		this.grammar = grammar;
		this.alphabet = this.grammar.getAlphabet();
		this.nonterminalMap = nonterminalMap;
	}
}

rules
@init {
	for(NonterminalInfo nI : nonterminalMap.values())
	{ 
		nI.nonterminal = alphabet.addNonTerminal(nI.label, nI.typeSequence, nI.entrance);
	}
}
	: (^( RULE rule {
			NonterminalInfo nI = this.nonterminalMap.get($rule.nonterminal);
			this.grammar.addRule(nI.nonterminal, $rule.graph);
		} ))*
;

rule returns [String nonterminal, HyperGraph graph]
@init {
	Map<String, NodeInfo> nodemap = new HashMap<String, NodeInfo>();
	
	$graph = new HyperGraph();
}
	: 	^(DEFINITION ^(TYPE name=ID) defnodes=def_tuple[name.getText()]
			{
				$nonterminal = $name.getText();
				int ext = 0;
				for (NodeInfo n: $defnodes.nodes)
				{ // add all external nodes
					n.id = $graph.newNode(n.type);
					$graph.insertExternal(ext++, n.id);
					nodemap.put(n.label, n);
					if (n.reduct)
					{
						$graph.setNodeTentacle(n.id, n.type.getReductionTentacle());
					}
				} 
			}
		)
		(
			^(EDGE ^(TYPE name=ID) nodes=edge_tuple[$nonterminal])
			{
				List<NodeInfo> nodelist = new LinkedList<NodeInfo>();
				for (NodeInfo n: $nodes.nodes)
				{ // add all internal nodes
					
					if (nodemap.containsKey(n.label)) n = nodemap.get(n.label);
					else
					{
						n.id = $graph.newNode(n.type);
						nodemap.put(n.label, n);
					}
					nodelist.add(n);
				}
				
				NonterminalInfo nt = this.nonterminalMap.get($name.getText());
				
				if (nt == null)
				{ // nonterminal not yet in nonterminalMap
					Nonterminal nonterm = alphabet.getNonterminal($name.getText());
					if (nonterm != null)
	       			{ // but the alphabet already knows about it
						nt = new NonterminalInfo();
						nt.label = nonterm.getLabel();
						nt.entrance = new boolean[nonterm.getRank()];
						nt.typeSequence = new NodeType[nonterm.getRank()];
						for (int i = 0; i < nonterm.getRank(); i++)
						{
							nt.entrance[i] = nonterm.isEntrance(i);
							nt.typeSequence[i] = nonterm.getType(i);
						}
						nt.nonterminal = nonterm;
					}
				}
				if (nt != null)
				{ 
					if (nt.typeSequence == null)
					{ // was in nonterminalMap, but not fully initialized
						nt.typeSequence = new NodeType[nodelist.size()];
						for (int i = 0; i < nodelist.size(); i++)
						{
							nt.typeSequence[i] = nodelist.get(i).type;
						}
							
					}
					else
					{ // was in alphabet, check against current nodelist
						if (nt.typeSequence.length != nodelist.size())
							throw new HRGRankException(nt.label);
						for (int i = 0; i < nt.typeSequence.length; i++)
						{
							if (nt.typeSequence[i] != nodelist.get(i).type)
								throw new HRGNotTypedNonterminalException(nt.label);
						}
					}
					
					int[] nodeArray = new int[nodelist.size()];
					for (int i = 0; i < nodeArray.length; i++)
						nodeArray[i] = nodelist.get(i).id;
    				
					if (nt.nonterminal != null)
					{
    					$graph.addEdge(nt.nonterminal, nodeArray);
    				}
					else
					{
    					for (int i = 0; i < $graph.getNodeTentacle(nodeArray[0]).getSuccessorCount() && i < nodeArray.length; i++)
						{
							$graph.setSuccessorNode(nodeArray[0], i, nodeArray[i]);
    					}
					}
				}
				else
				{
    				int s = nodelist.get(0).type.getSelectorId($name.getText());
					if(s < 0)
						throw new HRGUnknownSelectorException(nodelist.get(0).type, $name.getText());
					$graph.setSuccessorNode(nodelist.get(0).id, s, nodelist.get(1).id);
				}
			}
		)*
;

def_tuple [String nonterminal] returns [List<NodeInfo> nodes]
@init {
	$nodes = new LinkedList<NodeInfo>();
}
	: 	(^(NODE cur=node {
			NodeInfo node = new NodeInfo();
			node.label = $cur.name;
			String type = $cur.type;
			if (type == null) type = NodeTypeCheck.types.get($nonterminal).get($nodes.size());
			node.type = this.alphabet.getNodeType(type);
			if(node.type == null)
				throw new HRGUnknownTypeException(type);
			node.reduct = TentacleReductionCollector.reduction.get($nonterminal).get($nodes.size());
			$nodes.add(node);
		} ))+
;


edge_tuple [String nonterminal] returns [List<NodeInfo> nodes]
@init {
	$nodes = new LinkedList<NodeInfo>();
}
	: 	(^(NODE cur=node {
			NodeInfo node = new NodeInfo();
			node.label = $cur.name;
			String type = $cur.type;
			if (type == null) type = NodeTypeCheck.types.get($nonterminal).get($nodes.size());
			node.type = this.alphabet.getNodeType(type);
			if(node.type == null)
				throw new HRGUnknownTypeException(type);
			$nodes.add(node);
		} ))+
;

node returns [ String name, String type ]
	: 	^(NAME n=ID)
			{ $name = $n.getText(); $type = null; }
	|	^(TYPE t=ID) ^(NAME n=ID)
			{ $name = $n.getText(); $type = $t.getText(); }
	|	NULL
			{ $name = "null"; $type = "Null"; }
;