tree grammar HRGWalkerGrammar;

options {
	language=Java;
	tokenVocab=HRG;
	output=AST;
	ASTLabelType=CommonTree;
}

@header {
	package de.rwth.aachen.i2.graphreduction.newgrammar;
	
	import de.rwth.aachen.i2.graphreduction.newgrammar.utils.*;
	import java.util.LinkedList;
}

@members {
	private BaseObserver observer;
	
	public void setObserver(BaseObserver observer)
	{
		this.observer = observer;
	}
}


rules returns [ boolean res ]
@init {
	if (this.observer == null)
	{
		this.emitErrorMessage("Sorry, the observer variable is null.\nWe'll very probably crash at some point.\nPlease use HRGTreeGrammar.setObserver() so change it.");
	}
}
	: 	{ $res = this.observer.init(); } 
		(^( RULE rule { $res &= $rule.res; } ))*
		{ $res &= this.observer.validate(); }
;

rule returns [ boolean res ]
	: 	^(DEFINITION ^(TYPE name=ID) nodes=tuple)
			{ $res = this.observer.startRule($name.token, $nodes.nodes); }
		(
			^(EDGE ^(TYPE name=ID) nodes=tuple)
			{ $res &= this.observer.edge($name.token, $nodes.nodes); }
		)*
			{ $res &= this.observer.endRule($name.token); }
		
;

tuple returns [ List<Definition> nodes ]
@init {
	$nodes = new LinkedList<Definition>();
}
	: 	(^(NODE cur=node { $nodes.add(new Definition($cur.name, $cur.type)); } ))+
;

node returns [ Token name, Token type ]
	: 	^(NAME n=ID)
			{ $name = $n.token; $type = null; }
	|	^(TYPE t=ID) ^(NAME n=ID)
			{ $name = $n.token; $type = $t.token; }
	|	NULL
			{ $name = null; $type = null; }
;