package de.rwth.aachen.i2.graphreduction.newgrammar.observer;

import java.util.List;

import org.antlr.runtime.Token;
import org.antlr.runtime.tree.TreeParser;

import de.rwth.aachen.i2.graphreduction.newgrammar.utils.BaseObserver;
import de.rwth.aachen.i2.graphreduction.newgrammar.utils.Definition;
import de.rwth.aachen.i2.graphreduction.newgrammar.utils.ErrorHandler;

/**
 * checks for every rule if it is increasing.
 * a rule is increasing, if it produces at least one terminal edge or two nonterminal edges.
 * a rule is not increasing, if it produces only one nonterminal.
 *
 * @author Gereon
 */
public class IncreasingCheck extends BaseObserver
{
	
	private boolean curContainsTerminal = false;
	private int curEdgeCount = 0;

	/**
	 * create a new {@link IncreasingCheck}
	 * @param parser parser object
	 */
	public IncreasingCheck(TreeParser parser)
	{
		super(parser);
		this.addDependency("NonTerminalCollector");
	}

	@Override
	public boolean init()
	{
		return true;
	}

	@Override
	protected boolean ruleStart(Token nonterminal, List<Definition> nodes)
	{
		this.curContainsTerminal = false;
		this.curEdgeCount = 0;
		return true;
	}

	@Override
	protected boolean ruleEnd(Token nonterminal)
	{
		if (this.curContainsTerminal) return true;
		if (this.curEdgeCount > 1) return true;
		ErrorHandler.emitError(this.curRule, "Rule is not increasing.");
		return false;
	}

	@Override
	public boolean edge(Token edgename, List<Definition> nodes)
	{
		this.curEdgeCount++;
		if (NonTerminalCollector.terminals.contains(edgename.getText()))
		{
			this.curContainsTerminal = true;
		}
		return true;
	}

	@Override
	public boolean validate()
	{
		return true;
	}

}
