package de.rwth.aachen.i2.graphreduction.newgrammar.observer;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

import org.antlr.runtime.Token;
import org.antlr.runtime.tree.TreeParser;

import de.rwth.aachen.i2.graphreduction.newgrammar.utils.BaseObserver;
import de.rwth.aachen.i2.graphreduction.newgrammar.utils.Definition;
import de.rwth.aachen.i2.graphreduction.newgrammar.utils.ErrorHandler;

/**
 * checks if all nodes are named consistently
 * 
 * this check ensures, that the external nodes of each rule are named identically for each nonterminal.
 *
 * @author Gereon
 */
public class NodeNameCheck extends BaseObserver
{
	/**
	 * create a new {@link NodeNameCheck}
	 * @param parser parser object
	 */
	public NodeNameCheck(TreeParser parser)
	{
		super(parser);
	}

	private HashMap<String, List<String>> nodenames = new HashMap<String, List<String>>();
	
	@Override
	protected boolean ruleStart(Token nonterminal, List<Definition> nodes)
	{
		String name = nonterminal.getText();
		if (this.nodenames.containsKey(name))
		{
			List<String> list = this.nodenames.get(name);
			boolean result = true;
			for (int i=0; i < nodes.size() && i < list.size(); i++)
			{
				Definition def = nodes.get(i);
				if (def.name == null) continue;
				else if (list.get(i) == null) list.set(i, def.name.getText());
				else if (!def.name.getText().equals(list.get(i)))
				{
					
					ErrorHandler.emitError(def.name, "Node with type \"" + def.type.getText() + "\" is named \"" + def.name.getText() + "\" but was previously named \"" + list.get(i) + "\""); 
					result = false;
				}
			}
			return result;
		}
		else
		{
			LinkedList<String> list = new LinkedList<String>();
			for (Definition def: nodes)
			{
				if (def.name == null) list.add(null);
				else list.add(def.name.getText());
			}
			this.nodenames.put(name, list);
		}
		return true;
	}

	@Override
	public boolean edge(Token edgename, List<Definition> nodes)
	{
		return true;
	}

	@Override
	public boolean init() {
		return true;
	}

	@Override
	protected boolean ruleEnd(Token nonterminal) {
		return true;
	}

	@Override
	public boolean validate() {
		return true;
	}
}
