package de.rwth.aachen.i2.graphreduction.newgrammar.observer;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

import org.antlr.runtime.Token;
import org.antlr.runtime.tree.TreeParser;

import de.rwth.aachen.i2.graphreduction.newgrammar.utils.BaseObserver;
import de.rwth.aachen.i2.graphreduction.newgrammar.utils.Definition;
import de.rwth.aachen.i2.graphreduction.newgrammar.utils.ErrorHandler;

/**
 * checks type consistency for all nodes
 * 
 * this class checks if the external nodes types are equal to the nodes that are incident to the nonterminal for each rule.
 * an error is thrown, if some type conflict occurs.
 *
 * @author Gereon
 */

public class NodeTypeCheck extends BaseObserver
{
	/**
	 * create a new {@link NodeTypeCheck}
	 * @param parser parser object
	 */
	public NodeTypeCheck(TreeParser parser)
	{
		super(parser);
		this.addDependency("NodeTypeCollector");
		this.addDependency("RuleConnectedCheck");
	}

	/**
	 * Node types
	 * 
	 * for each nonterminal, there is a list of types for the external nodes of this nonterminal.
	 */
	public static HashMap<String, List<String>> types = new HashMap<String, List<String>>();
	
	@Override
	protected boolean ruleStart(Token nonterminal, List<Definition> nodes)
	{
		String name = nonterminal.getText();
		if (NodeTypeCheck.types.containsKey(name))
		{
			List<String> list = NodeTypeCheck.types.get(name);
			
			if (nodes.size() != list.size())
			{
				ErrorHandler.emitError(nonterminal, "Definition has " + nodes.size() + " nodes, but \"" + name + "\" was previously declared with " + list.size() + " nodes.");
				return false;
			}
			boolean result = true;
			for (int i=0; i < nodes.size(); i++)
			{
				String type = NodeTypeCollector.nodetypes.get(this.ruleNumber).get(nodes.get(i).getName());
				if (!type.equals(list.get(i)))
				{
					ErrorHandler.emitError(nonterminal, "Edge \"" + name + "\" gets \""+ nodes.get(i).getName() + "\" with type \"" + type + "\" but was previously declared to get type \"" + list.get(i) + "\"");
					result = false;
				}
			}
			return result;
		}
		else
		{
			LinkedList<String> list = new LinkedList<String>();
			for (Definition def: nodes)
			{
				list.add(NodeTypeCollector.nodetypes.get(this.ruleNumber).get(def.getName()));
			}
			NodeTypeCheck.types.put(name, list);
		}
		return true;
	}

	@Override
	public boolean edge(Token edgename, List<Definition> nodes)
	{ // just do the same as in ruleStart, so why not call it? 
		return this.ruleStart(edgename, nodes);
	}

	@Override
	public boolean init() {
		return true;
	}

	@Override
	protected boolean ruleEnd(Token nonterminal) {
		return true;
	}

	@Override
	public boolean validate() {
		return true;
	}
}
