package de.rwth.aachen.i2.graphreduction.newgrammar.observer;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.antlr.runtime.Token;
import org.antlr.runtime.tree.TreeParser;

import de.rwth.aachen.i2.graphreduction.newgrammar.utils.BaseObserver;
import de.rwth.aachen.i2.graphreduction.newgrammar.utils.Definition;
import de.rwth.aachen.i2.graphreduction.newgrammar.utils.ErrorHandler;

/**
 * collects all terminals and nonterminals
 * 
 * this class collects all symbols and distinguishes between terminals and nonterminals.
 * an error is thrown if a terminal symbol occurs that has only one or more than two external nodes.
 *
 * @author Gereon
 */
public class NonTerminalCollector extends BaseObserver
{
	/**
	 * set of terminal edges
	 */
	public static Set<String> terminals;
	/**
	 * set of nonterminal edges
	 */
	public static Set<String> nonterminals;
	
	/**
	 * create a new {@link NonTerminalCollector}
	 * @param parser parser object
	 */
	public NonTerminalCollector(TreeParser parser)
	{
		super(parser);
		NonTerminalCollector.terminals = new HashSet<String>();
		NonTerminalCollector.nonterminals = new HashSet<String>();
		this.addDependency("NodeTypeCheck");
	}

	@Override
	protected boolean ruleStart(Token nonterminal, List<Definition> nodes)
	{
		String text = nonterminal.getText();
		if (NonTerminalCollector.terminals.contains(text))
		{
			NonTerminalCollector.terminals.remove(text);
		}
		NonTerminalCollector.nonterminals.add(text);
		return true; 
	}
	
	@Override
	public boolean edge(Token edgename, List<Definition> nodes)
	{
		String text = edgename.getText();
		if (!NonTerminalCollector.nonterminals.contains(text))
		{
			NonTerminalCollector.terminals.add(text);
		}
		return true; 
	}

	@Override
	public boolean init() {
		return true;
	}

	@Override
	protected boolean ruleEnd(Token nonterminal) {
		return true;
	}

	@Override
	public boolean validate() {
		boolean res = true;
		for (String term: NonTerminalCollector.terminals)
		{
			if (NodeTypeCheck.types.get(term).size() != 2)
			{
				ErrorHandler.emitError("\"" + term + "\" is said to be a nonterminal, as no rules are present. However, it has " + NodeTypeCheck.types.get(term).size() + " nodes instead of 2.");
				res = false;
			}
		}
		return res;
	}
}
