package de.rwth.aachen.i2.graphreduction.newgrammar.observer;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.antlr.runtime.Token;
import org.antlr.runtime.tree.TreeParser;

import de.rwth.aachen.i2.graphreduction.newgrammar.utils.BaseObserver;
import de.rwth.aachen.i2.graphreduction.newgrammar.utils.Definition;
import de.rwth.aachen.i2.graphreduction.newgrammar.utils.ErrorHandler;

/**
 * checks if all rules are interconnected
 *
 * @author Gereon
 */
public class RuleConnectedCheck extends BaseObserver
{
	/**
	 * create a new {@link RuleConnectedCheck}
	 * @param parser parser object
	 */
	public RuleConnectedCheck(TreeParser parser)
	{
		super(parser);
	}
	
	private Set<Set<String>> groups = new HashSet<Set<String>>();

	@Override
	public boolean init() {
		return true;
	}

	@Override
	protected boolean ruleStart(Token nonterminal, List<Definition> nodes)
	{
		this.groups.clear();
		for(Definition def: nodes)
		{
			HashSet<String> s = new HashSet<String>();
			s.add(def.getName());
			this.groups.add(s);
		}
		return true;
	}

	@Override
	public boolean edge(Token edgename, List<Definition> nodes)
	{
		Set<String> g = null;
		for (Definition def: nodes)
		{
			String n = def.getName();
			for (Iterator<Set<String>> it = this.groups.iterator(); it.hasNext(); )
			{ // merge all sets that are incident to this node
				Set<String> grp = it.next();
				if (!grp.contains(n)) continue;
				if (g == null) g = grp;
				else
				{
					g.addAll(grp);
					it.remove();
				}
			}
		}
		return true;
	}
	
	@Override
	protected boolean ruleEnd(Token nonterminal)
	{
		if (this.groups.size() > 1)
		{
			ErrorHandler.emitError(nonterminal, "The following rule were not interconnected: " + this.curRule.getText() + ", the rule is divided into the follwing node sets:");
			for (Set<String> grp: this.groups) ErrorHandler.emitError(grp.toString());
			
			return false;
		}
		return true;
	}
	
	@Override
	public boolean validate() {
		return true;
	}
}
