package de.rwth.aachen.i2.graphreduction.newgrammar.utils;

import org.antlr.runtime.Token;

/**
 * pair of strings, representing a definition of a node and (optional) type within an edge.
 *
 * @author Gereon
 */
public class Definition
{
	/**
	 * node type
	 */
	public Token type;
	/**
	 * node name within a rule
	 */
	public Token name;
	
	/**
	 * only a name is given
	 * @param name name Token
	 */
	public Definition(Token name)
	{
		this.type = null;
		this.name = name;
	}
	/**
	 * name and type are given
	 * @param name name Token
	 * @param type type Token
	 */
	public Definition(Token name, Token type)
	{
		this.type = type;
		this.name = name;
	}
	
	/**
	 * return name as a {@link String}
	 * @return name
	 */
	public String getName()
	{
		if (this.name == null) return "NULL";
		else return this.name.getText();
	}
	
	/**
	 * return object representation as a {@link String}
	 */
	public String toString()
	{
		if (this.type == null) return this.getName();
		else return this.getName() + "\\n(" + this.type.getText() + ")";
	}
}
