package de.rwth.aachen.i2.graphreduction.newgrammar.utils;

import java.util.Set;

/**
 * interface for objects that have dependencies that can be resolved with the {@link DependencyScheduler}.
 * 
 * there is only one specified method, {@link #getDependencies()}.
 * the internal handling of adding dependencies is left to the implementing class.
 * this allows some kind of lazy object retrieval, see {@link BaseObserver} for this.
 *
 * @author Gereon
 */
public interface DependencyObject
{
	/**
	 * get all objects that this object depends on
	 * @return set of dependencies
	 */
	public Set<DependencyObject> getDependencies();
}
