package de.rwth.aachen.i2.graphreduction.newgrammar.utils;

/**
 * base class for all objects with attributes that can be inferred from other objects of the same type.
 * 
 * those attributes can be computed with an {@link InferenceSolver}. 
 *
 * @author Gereon
 * @param <T> the object class, should be the class itself
 * @param <I> the information class
 */
public abstract class InferenceObject<T extends InferenceObject<T, I>, I extends InferenceInformation>
{
	/**
	 * true, if it is already an inferred value
	 */
	public boolean infered = false;
	/**
	 * first inference. some information of the object should be calculated here, based on the condition object and the given information
	 * @param condition the object we need data from
	 * @param information additional information about the inference
	 * @return false if inference could not be done for some normal reason
	 * @throws InferenceException should be thrown if inference should fail for some reason
	 */
	public abstract boolean inferFrom(T condition, I information) throws InferenceException;
	
	/**
	 * repeated inference, check previously calculated data for consistency.
	 * @param condition the object we need data from
	 * @param information additional information about the inference
	 * @throws InferenceException should be thrown if inference should fail for some reason or the calculated data is different from the one previously calculated 
	 */
	public abstract void checkInference(T condition, I information) throws InferenceException;
	
	/**
	 * an {@link InferenceObject} must implement {@link #equals(Object)} to avoid duplication in the inference graph.
	 * while it should not affect the correctness, performance and understandability might decrease.
	 * @param obj the object to compare to, will always be another {@link InferenceObject}  
	 * @return true, if the object is equal to the given object
	 */
	public abstract boolean equals(Object obj);
	
	/**
	 * copy object contents from obj
	 * @param obj object to copy from
	 */
	public abstract void copyFrom(T obj);
}
