package de.rwth.aachen.i2.graphreduction.newgrammar.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/**
 * central place to register observers that should be executed.
 * 
 * the observer objects are indexed by its class name to implicitly enforce some kind of singleton.
 * 
 * each observer can be assigned 
 *
 * @author Gereon
 */
public class ObserverRegister
{
	/**
	 * all observers go here, indexed by the simple class name
	 */
	private static Map<String, BaseObserver> observers = new HashMap<String, BaseObserver>();
		
	/**
	 * register a new observer 
	 * @param observer the new observer
	 */
	public static void register(BaseObserver observer)
	{
		ObserverRegister.observers.put(observer.getClass().getSimpleName(), observer);
	}
	
	/**
	 * get a collection of all registered observers
	 * @return registered observers
	 */
	public static Collection<BaseObserver> getObservers()
	{
		return ObserverRegister.observers.values();
	}
	
	/**
	 * get an observer by its class name
	 * @param name class name
	 * @return observer object
	 */
	public static BaseObserver getObserver(String name)
	{
		if (!ObserverRegister.observers.containsKey(name))
		{
			System.err.println("Error while retrieving dependency. " + name + " does not exist. This will probably produce an error later on.");
		}
		return ObserverRegister.observers.get(name);
	}
}
